/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/
/**
 * \file    DM814x_types.h
 *
 * \brief   Defines the statndard types for CCS sample code
 *
 * This header file contains the standard typedefs and macros
 * for use with CCS test code for DM814X EVM.
 *
 * \author  0043
 *
 * \version 01a,09aug,2010 Created.
 */

#ifndef _DM814x_types_H_
#define _DM814x_types_H_

#ifdef __cplusplus
 extern "C" {
#endif

/*
 *====================
 * Includes
 *====================
 */

/**
@addtogroup DM814x Types
@{
*/

/*
 *====================
 * Defines
 *====================
 */
#define SUCCESS		0
#define FAILED		-1

#define SW_BREAKPOINT       asm( " .long 0xe1200070" );

#ifndef NULL
#define NULL 0
#endif

/*
 *====================
 * Typedefs
 *====================
 */
typedef unsigned char 	UINT8;
typedef unsigned short 	UINT16;
typedef unsigned int 	UINT32;
typedef char 	INT8;
typedef short 	INT16;
typedef int 	INT32;
typedef int 	STATUS;

/* @} */   /* End of DM814x Types */

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM814x_types_H_ */
